# Reviewer Export Outline

This outline matches how reviewers validate evidence: context, scope, controls, artifacts, exceptions, and next steps.

## Recommended Export Conventions
- Use a stable Evidence ID scheme (for example, `GOV-`, `IAM-`, `LOG-`, `IR-`, `SDLC-`).
- Put an index first. Reviewers should not hunt through folders.
- Include capture dates and refresh cadence for every artifact.
- Separate public, verified, and agreement-required artifacts (tiering reduces friction).

If you want a fill-in document you can save as a PDF, start with `09-reviewer-export-template.md`.

1) **Executive summary (one page)**
   - What you protect, how you protect it, and how to request more information
   - Include: scope date, primary security contact, and sharing model

2) **Scope and architecture**
   - Product and environment scope
   - Data flows (diagram)
   - Data retention and deletion overview

3) **Governance**
   - Written information security program (WISP) or equivalent
   - Policy set and approval history
   - Ownership and review cadence

4) **Controls and reviewer index**
   - A table: control area, Evidence ID, artifact name, capture date, owner
   - Use `05-reviewer-index-template.csv` as your source of truth

5) **Security operations**
   - Logging and monitoring coverage (what is logged, retention, access controls)
   - Incident response playbook
   - Example incident timeline format

6) **Secure software delivery and change management**
   - Review and deploy controls
   - Secure software development lifecycle (SDLC) practices and evidence
   - Vulnerability management cadence

7) **Vendor and subprocessor oversight**
   - Subprocessor list
   - Due diligence workflow and example export structure

8) **Readiness and training**
   - Training completion report
   - Tabletop exercise and phishing simulation evidence (if applicable)

9) **Third-party validation**
   - SOC 2 (System and Organization Controls) report or penetration test summary (when available)
   - Notes on scope and timing

10) **Exceptions and remediation plan**
   - What is not implemented yet (if anything)
   - Owners, dates, and the evidence you will provide when complete

11) **Contact and next steps**
   - How to request access to additional documents
   - Timeline expectations for follow-up

## Optional: Exceptions Template
Reviewers accept honest gaps when they are owned and dated.

- Exception: {What is not implemented or not available}
- Scope: {What it affects}
- Risk: {Why it matters}
- Compensating controls: {What reduces the risk today}
- Owner: {Person or team}
- Target date: {YYYY-MM-DD}
- Evidence you will provide when complete: {Evidence ID}

## Practical Tips (What Makes Reviewers Happy)
- Keep it skimmable: one or two pages of narrative, then the reviewer index and evidence.
- Cite Evidence IDs everywhere. “See attached” creates follow-ups.
- Add capture dates and cadence so reviewers trust freshness.
- Gate sensitive reports instead of refusing or over-sharing.

