# Aurora Command Tabletop Exercise Kit

Run a tabletop exercise that produces a defensible readiness record (not just a meeting).

This kit helps you:
- Validate detection, containment, escalation, and communications under pressure.
- Produce evidence artifacts you can reuse for audits and buyer security reviews.
- Convert gaps into owned remediation work with dates and evidence.

## Who this is for
- Security lead / incident commander
- Engineering / operations leaders
- Comms/legal stakeholders involved in incident response
- Anyone who needs a repeatable, evidence-producing incident readiness program

## Expected outputs (what you will produce)
- A complete timeline (injects, decisions, actions, evidence captured)
- An After-Action Report (AAR) with gaps and remediation owners
- A remediation tracker you can follow to closure
- A repeatable scoring rubric so each run produces measurable improvement

## Scope (what this kit covers)
- Tabletop exercises for security incidents (phishing, credential compromise, data exposure, third-party compromise, etc.)
- Role clarity and decision-making under time pressure
- Evidence outputs that can be reused for audits and buyer security reviews (AAR, remediation trail)
- Communications patterns (internal updates, customer holding statement, cadence)

This kit does not provide legal advice and does not replace a technical incident response runbook.

## Included files
- `facilitator-guide.md`: prep checklist, timeboxing, and how to run the session
- `scenarios.md`: scenario outlines with objectives, assumptions, and decision points
- `roles-and-injects.md`: role responsibilities and copy/paste inject prompts
- `injects-library.csv`: a reusable inject library (pick and schedule your run)
- `communications-templates.md`: internal update, customer holding statement, status update templates
- `after-action-report-template.md`: AAR format designed for audits and reviewers
- `session-timeline-template.csv`: record injects, decisions, actions, and evidence captured
- `remediation-tracker.csv`: convert gaps into owned work with evidence links
- `metrics-and-scoring.md`: optional scoring rubric (useful for repeatable improvements)

## Quick start (60 minutes)
1) Pick one scenario from `scenarios.md` and assign an incident commander and facilitator.
2) Copy `session-timeline-template.csv` and pre-load the injects you plan to run.
3) Run a 45-minute session (keep it tight): injects, decisions, actions, evidence captured.
4) Immediately fill the AAR while context is fresh. Create remediation items for every gap.
5) Track remediation to closure and attach evidence (policy update, config export, runbook change).

## How to run a tabletop that produces audit-ready artifacts
### Before the session (prep checklist)
- Choose a scenario that matches your real risk profile and tool stack.
- Confirm participants and roles (IC, security lead, engineering lead, comms/legal).
- Set the ground rules: use assumptions, state uncertainties, and record decisions.
- Decide what you will capture as “evidence outputs”:
  - Timeline, decisions, actions
  - Comms artifacts
  - Remediation items with owners/dates

### During the session (timeboxing that works)
- Keep injects moving; do not debate implementation details.
  Your goal is decision quality and evidence capture.
- For each inject, record:
  - What was observed
  - What decision was made
  - What action was taken
  - What evidence you would capture in a real incident

### After the session (follow-through)
- Fill the AAR immediately while context is fresh.
  If you wait a week, gaps become arguments and nothing closes.
- Create remediation work for every gap.
  Close items only when evidence exists (updated runbook, config export, approved template, etc.).

## Quality bar (what makes a tabletop “defensible”)
- Clear ownership (IC and role responsibilities are explicit).
- Decisions are recorded with timestamps and rationale.
- Gaps become remediation work with owners and due dates.
- Remediation closes only with evidence (not “we talked about it”).
- Outputs are sanitized if shared outside the org.

## Notes
- This kit is informational and is not legal advice.
- Use sanitized data in tabletop artifacts if you plan to share them outside your org.
