# Communications Templates (Copy/Paste)

These are intentionally short and structured. Replace placeholders in `{braces}`.

## Template A: Internal incident update (engineering and execs)

Subject: Incident update: {Short label} - {Timestamp}

Status: {Investigating / Contained / Recovering / Resolved}
Severity: {Low/Med/High}

What we know
- {Bullet 1}
- {Bullet 2}

What we’re doing now
- {Action 1} (owner: {Name})
- {Action 2} (owner: {Name})

Next update: {Time}

## Template A2: Slack/Teams internal update (short)

`{incident-channel}`

Status: *{Investigating / Contained / Recovering / Resolved}* • Severity: *{Low/Med/High}*

What we know:
- {bullet 1}
- {bullet 2}

Now:
- {action 1} (owner: {name})
- {action 2} (owner: {name})

Next update: {time}

## Template B: Customer holding statement (short)

Hi {Name},

We’re investigating an issue that may impact {system/service}. At this time, we do not have evidence of customer data exposure, but the investigation is ongoing.

We’ll provide an update by {time} (or sooner if we confirm material impact). If you have specific requirements for notifications, please share them now so we can align.

Best,
{Name}
{Title}

## Template B2: Customer update (when scope is clearer)

Hi {Name},

Update on {incident label} as of {timestamp}:
- Impact: {what is impacted; include scope and who is affected}
- Data exposure: {none observed / suspected / confirmed} (scope: {data categories/time window})
- Actions taken: {containment/recovery actions}

Next update: {time} (or sooner if new material information is confirmed).

If you have specific notification requirements or contacts for security updates, please share them and we will align.

Best,
{Name}

## Template C: Status page update (public)

Title: {Service} - {Issue label}

We are investigating reports of {symptom}. We will post updates as they are available.

Update cadence: every {N} minutes.

## Template C2: Status page resolution notice

Title: {Service} - Resolved - {Issue label}

We have resolved the incident affecting {system/service}. {Brief summary of what happened at a high level}.

If you experienced impact and need additional details, contact {support channel}.

We will publish a post-incident review within {time window} when available.

## Template D: Vendor escalation request (when a vendor is involved)

Hi {Vendor contact},

We received notice of a potential security incident. To assess impact, please provide:
- Scope and timeline (first detected, period of exposure)
- Systems affected
- Data involved (categories, volume, whether customer data was accessed)
- Containment actions taken
- Next update time and point of contact

Deadline for initial response: {time/date}

Thanks,
{Name}

## Template D2: Vendor follow-up (when details are missing)

Hi {Vendor contact},

Following up on the incident notice. We still need the following to assess impact:
- Confirmed timeline (first detected, period of exposure)
- Customer impact statement (whether our tenant/account is impacted)
- Data categories affected (if any) and how confirmed
- Evidence/IOCs we can use to validate impact on our side
- Next update time and a single point of contact

Deadline: {time/date}

Thanks,
{Name}

## Template E: Executive update (30-second read)

Subject: Exec update: {incident label} - {timestamp}

Status: {Investigating / Contained / Recovering / Resolved} • Severity: {Low/Med/High}

Impact
- {who/what is impacted}

Risk summary
- Data exposure: {none observed / suspected / confirmed} (scope: {data categories/time window})

Actions
- {action 1}
- {action 2}

Next update: {time}

## Template F: Press inquiry response (short)

Hi {Name},

We are investigating an incident affecting {system/service}. We will share material updates through our official channels as they are confirmed.

For questions, please contact {press contact email}.

Thanks,
{Name}
