# Facilitator guide (runbook)

This runbook is designed to keep the exercise focused and produce artifacts you can reuse: a timeline, an AAR, and a remediation tracker.

## Recommended duration
- 45 minutes: scenario run (injects and decisions)
- 15 minutes: immediate debrief (capture gaps while fresh)
- 30–60 minutes (optional): AAR write-up and remediation assignment

## Prep checklist (before the session)
- Pick one scenario from `scenarios.md` and decide what “success” means.
- Assign roles (minimum):
  - Facilitator (runs injects, keeps time)
  - Incident commander (owns decisions)
  - Security lead (technical containment)
  - Comms lead (internal/customer updates)
- Decide the comms channel used during a real incident (Slack channel, bridge, etc.).
- Copy `session-timeline-template.csv` and pre-load your inject schedule (include inject IDs).
- Decide what evidence you will capture (minimum):
  - Timeline export (filled CSV)
  - Attendance record (names and roles)
  - AAR (filled template)
  - Remediation tracker (owned items)
- Optional: choose a scoring method from `metrics-and-scoring.md`.

## Ground rules (read at the start)
- This is a learning exercise, not a performance review.
- Make decisions with the information available in the inject; don’t assume perfect visibility.
- Capture assumptions in the timeline (“we assumed X; later we learned Y”).
- When stuck, decide and move on. Document the gap as remediation.

## Facilitator tips (how to keep it high-signal)
- Keep the scenario moving. Do not let the group debate hypotheticals for 10 minutes.
- When someone says “it depends”, ask: “What would you do first while we figure it out?”
- When a decision is made, record who approved it and what evidence you’d preserve.
- If the group lacks visibility (e.g., no one knows log retention), treat that as a gap to remediate.

## Recommended agenda (45 minutes)
1) 0–5: Confirm scope and roles; state objectives.
2) 5–35: Run injects; record decisions and actions taken.
3) 35–45: Quick debrief: top 3 strengths, top 3 gaps, top 3 follow-ups.

## How to “run” each inject
For every inject:
1) Read the inject out loud.
2) Ask: “What is the first action?” and “Who owns the decision?”
3) Ask: “What evidence do we want to preserve?”
4) Record the outcome in `session-timeline-template.csv`:
   - Decision owner
   - Actual response
   - Evidence captured (export, log, screenshot, approval)
5) If an answer is unclear, record it as a gap and move on.

## After the session (10-minute closeout)
- Assign an owner and due date for every gap in `remediation-tracker.csv`.
- Decide what to share externally (if anything). Keep tabletop artifacts sanitized by default.
- Schedule a 30-minute follow-up to close the AAR and confirm remediation owners.

## Optional: How to score and show improvement
If you want a repeatable program, score the session using `metrics-and-scoring.md` and record:
- Category scores (0–3) and brief rationale
- Top 3 improvements to target before the next tabletop
- Date for the next run (6 months is a common cadence)

## Optional: Evidence you can attach to a buyer or auditor request
- Tabletop AAR (sanitized)
- Remediation tracker excerpt (titles, owners, status)
- Updated incident response playbook with version history/approvals
