# Tabletop Scenarios

These scenarios are designed to produce artifacts you can reuse: a timeline, an After-Action Report (AAR), and remediation items.

## How to run
1) Pick a scenario and agree on scope and assumptions.
2) Choose injects from `injects-library.csv` (or write your own) and pre-load them into the session timeline.
3) Record decisions and evidence captured in `session-timeline-template.csv`.
4) Convert gaps into owned work in `remediation-tracker.csv`.

## What “success” looks like (regardless of scenario)
- Roles are assigned and decision ownership is clear.
- The incident is declared (or intentionally not declared) with a clear rationale.
- First actions are prioritized and time-boxed.
- Internal and customer communications cadence is set early.
- Evidence is preserved before risky changes where possible.
- The session produces artifacts: timeline, AAR, remediation tasks with owners and due dates.

---

## Scenario 1: Phishing leading to account takeover

Objective
- Validate detection, containment, escalation, and access recovery.

Assumptions (tailor)
- The affected identity has access to a production system or a critical admin tool.
- Logs exist, but visibility may be imperfect or delayed.

Suggested inject arc
- Initial report and login anomaly
- MFA fatigue / repeated prompts
- Customer asks for an update within 30 minutes
- Confirmed compromise; need token/session revocation

Suggested inject IDs (from `injects-library.csv`)
- INJ-PA-001, INJ-PA-002, INJ-PA-003, INJ-PA-004, INJ-PA-005, INJ-PA-006

Key decisions to test
- What triggers incident declaration and severity classification?
- Who can approve account lockouts and emergency access changes?
- When (and how) do you communicate externally?

Evidence to capture
- Access log export excerpt (sanitized)
- Decision record (who approved what, when)
- Customer holding statement draft (even if not sent)

---

## Scenario 2: Ransomware with business disruption

Objective
- Validate backups, containment, and decision-making under time pressure.

Assumptions (tailor)
- Some endpoints or servers show encryption indicators.
- Backups exist, but restore time is uncertain.

Suggested inject arc
- Alert: encryption indicators detected
- Business impact: key workflow down
- Restore prioritization: what comes back first?
- Executive pressure: “How long until we’re back?”

Suggested inject IDs
- INJ-RW-001, INJ-RW-002, INJ-RW-003, INJ-RW-004, INJ-RW-005

Key decisions to test
- Isolation boundaries: what do you take offline?
- Restore strategy and priority (RTO/RPO reality)
- Criteria for engaging legal/forensics/insurance (if applicable)

Evidence to capture
- Backup verification / restore test record excerpt
- Timeline of containment and restore decisions
- Status update cadence and owner

---

## Scenario 3: Vendor breach impacting customer data

Objective
- Validate vendor escalation, scope validation, and customer communications.

Assumptions (tailor)
- The vendor is a subprocessor or has access to customer data.
- The vendor’s initial notice is incomplete.

Suggested inject arc
- Vendor notice: “possible incident” (limited details)
- Scope ambiguity: data categories and time window unknown
- Contract pressure: notification timelines and deliverables
- Customer asks: “Are we impacted?”

Suggested inject IDs
- INJ-VB-001, INJ-VB-002, INJ-VB-003, INJ-VB-004

Key decisions to test
- Required vendor deliverables and deadlines
- When to initiate customer notification preparations
- How to document risk acceptance vs mitigation steps

Evidence to capture
- Vendor communications log excerpt
- Decision record (what you assumed and why)
- Draft customer response and update cadence

---

## Scenario 4: Suspicious login and credential exposure

Objective
- Validate identity and access controls, incident triage, and access review workflow.

Assumptions (tailor)
- A privileged account shows impossible travel or high-risk login signals.
- A recent credential leak is suspected.

Suggested inject arc
- Detection: impossible travel alert
- Token/session revocation decision
- Access review: what was touched and what must be rotated?
- Follow-up: hardening and monitoring improvements

Suggested inject IDs
- INJ-SL-001, INJ-SL-002, INJ-SL-003, INJ-SL-004

Key decisions to test
- What triggers forced credential rotation and session invalidation?
- Who owns approvals for production access changes?
- How do you preserve evidence for audit/review later?

Evidence to capture
- IdP export excerpt (sanitized)
- Timeline with decision owners
- Remediation items (policy, tooling, monitoring)

---

## Scenario 5: Cloud credential leak and suspected data exposure

Objective
- Validate rapid key rotation, containment, and evidence preservation when cloud credentials are exposed.

Assumptions (tailor)
- A cloud access key or service credential was committed to a public repo or leaked via a third party.
- You have cloud audit logs, but they may be noisy.

Suggested inject arc
- Confirm exposure window and rotate immediately
- Investigate suspicious API calls and blast radius
- Decide the customer notification preparation plan

Suggested inject IDs
- INJ-CK-001, INJ-CK-002, INJ-CK-003

Key decisions to test
- What is the immediate kill-switch action, and who can approve it?
- What evidence do you preserve before you delete or rotate?
- How do you communicate uncertainty without over-claiming?

Evidence to capture
- Cloud audit log export excerpt (sanitized)
- Rotation record and approvals
- Assumptions log and decision trail

---

## Scenario 6: API key exposure and partner abuse

Objective
- Validate revocation, rotation, and customer/partner communications when an API credential is abused.

Assumptions (tailor)
- A partner key leaks or is abused; usage spikes and error rates increase.
- Rate limits and revocation exist, but will impact a subset of users.

Suggested inject arc
- Decide revoke vs throttle vs allowlist strategy
- Communicate impact to partner/customer
- Document time-boxed exceptions (if any)

Suggested inject IDs
- INJ-API-001, INJ-API-002

Key decisions to test
- What is the revocation and rotation plan, and what is the rollback?
- Who can authorize exceptions, and how are they logged and time-boxed?
- How do you ensure auditability of the change?

Evidence to capture
- API audit logs excerpt (sanitized)
- Rotation record and approvals
- Exception record (if any) with owner and expiry

---

## Scenario 7: Outage / DDoS with customer pressure for RCA

Objective
- Validate incident declaration, status communications, and safe mitigation decisions during an outage.

Assumptions (tailor)
- Traffic spike elevates errors; root cause is unclear early.
- Customers request frequent updates and immediate RCA.

Suggested inject arc
- Declare incident; set comms cadence early
- Mitigation actions may require risky configuration changes
- Handle early RCA pressure without speculation

Suggested inject IDs
- INJ-DDOS-001, INJ-DDOS-002, INJ-DDOS-003

Key decisions to test
- When do you publish a status update and how often?
- Who approves risky mitigations and how do you document it?
- How do you scope RCA commitments and timelines?

Evidence to capture
- Status update drafts
- Change record/approval trail for mitigations
- Timeline with decision ownership and assumptions
